/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWWorkflowCollectionPropertiesDialog
extends VWModalDialog
implements ActionListener {
    private static final Dimension DIM_DEFAULT_SIZE = new Dimension(385, 275);
    private JTextField m_nameTextField = null;
    private JLabel m_appSpacelabel = null;
    private JComboBox m_applicationSpaceCombo = null;
    private JTextArea m_descriptionTextArea = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWWorkflowCollectionDefinition m_workflowCollectionDef = null;
    private boolean m_bHasChanged = false;

    public VWWorkflowCollectionPropertiesDialog(VWDesignerCoreData designerCoreData) {
        super(designerCoreData.getParentFrame());
        this.m_designerCoreData = designerCoreData;
        this.setTitle(VWResource.s_packagePropertiesDialogTitle);
        this.setSize(DIM_DEFAULT_SIZE);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.createMainPanel();
        this.createButtonPanel();
    }

    public void reinitialize(VWWorkflowCollectionDefinition workflowCollectionDef) {
        try {
            this.m_workflowCollectionDef = workflowCollectionDef;
            this.m_bHasChanged = false;
            this.m_nameTextField.setText(this.m_workflowCollectionDef.getName());
            this.m_descriptionTextArea.setText(this.m_workflowCollectionDef.getDescription());
            VWApplicationSpaceDefinition[] appSpaceDefs = this.m_designerCoreData.getDataDictionary().getApplicationSpaces();
            if (appSpaceDefs != null) {
                this.m_applicationSpaceCombo.setModel(new DefaultComboBoxModel<VWApplicationSpaceDefinition>(appSpaceDefs));
            } else {
                this.m_applicationSpaceCombo.setModel(new DefaultComboBoxModel());
            }
            if (this.m_applicationSpaceCombo.getModel().getSize() > 0) {
                this.m_applicationSpaceCombo.setEnabled(true);
                String selectedName = this.m_workflowCollectionDef.getApplicationSpaceName();
                if (selectedName != null) {
                    VWApplicationSpaceDefinition appSpaceDef = this.m_designerCoreData.getDataDictionary().getApplicationSpace(selectedName);
                    this.m_applicationSpaceCombo.setSelectedItem(appSpaceDef);
                } else {
                    this.m_applicationSpaceCombo.setSelectedIndex(0);
                }
            } else {
                this.m_applicationSpaceCombo.setEnabled(false);
            }
            boolean bDisplay = this.m_designerCoreData.getApplicationMode() == 1;
            this.m_appSpacelabel.setVisible(bDisplay);
            this.m_applicationSpaceCombo.setVisible(bDisplay);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getHasChanged() {
        return this.m_bHasChanged;
    }

    public void releaseReferences() {
        this.m_nameTextField = null;
        this.m_appSpacelabel = null;
        if (this.m_applicationSpaceCombo != null) {
            this.m_applicationSpaceCombo.removeAll();
            this.m_applicationSpaceCombo = null;
        }
        this.m_descriptionTextArea = null;
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        this.m_designerCoreData = null;
        this.m_workflowCollectionDef = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_okButton)) {
                if (this.saveChanges()) {
                    this.m_nExitStatus = 0;
                    this.setVisible(false);
                }
            } else if (source.equals(this.m_cancelButton)) {
                this.m_nExitStatus = 1;
                this.setVisible(false);
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh167.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(4, 4, 0, 0);
            mainPanel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_nameStr)), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_nameTextField = new JTextField();
            this.m_nameTextField.setName("m_nameTextField_VWWorkflowCollectionPropertiesDialog");
            mainPanel.add((Component)this.m_nameTextField, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_appSpacelabel = new JLabel(VWResource.s_applicationSpace);
            mainPanel.add((Component)this.m_appSpacelabel, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_applicationSpaceCombo = new JComboBox();
            this.m_applicationSpaceCombo.setRenderer(new VWLabelListCellRenderer());
            mainPanel.add((Component)this.m_applicationSpaceCombo, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            mainPanel.add((Component)new JLabel(VWResource.s_colon.toString(VWResource.s_description)), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWWorkflowCollectionPropertiesDialog");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), gbCons);
            this.getContentPane().add((Component)mainPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 10;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setName("m_okButton_VWWorkflowCollectionPropertiesDialog");
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWWorkflowCollectionPropertiesDialog");
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWWorkflowCollectionPropertiesDialog");
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            this.getContentPane().add((Component)buttonPanel, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean saveChanges() {
        try {
            if (VWStringUtils.compare(this.m_nameTextField.getText(), this.m_workflowCollectionDef.getName()) != 0) {
                this.m_bHasChanged = true;
            }
            this.m_workflowCollectionDef.setName(this.m_nameTextField.getText());
            VWApplicationSpaceDefinition appSpaceDef = (VWApplicationSpaceDefinition)this.m_applicationSpaceCombo.getSelectedItem();
            if (appSpaceDef != null) {
                if (VWStringUtils.compare(appSpaceDef.getName(), this.m_workflowCollectionDef.getApplicationSpaceName()) != 0) {
                    this.m_bHasChanged = true;
                }
                this.m_workflowCollectionDef.setApplicationSpaceName(appSpaceDef.getName());
            }
            if (VWStringUtils.compare(this.m_descriptionTextArea.getText(), this.m_workflowCollectionDef.getDescription()) != 0) {
                this.m_bHasChanged = true;
            }
            this.m_workflowCollectionDef.setDescription(this.m_descriptionTextArea.getText());
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
            return false;
        }
    }
}

